
type binary_op= Plus | Minus | Mult | Div | PowF ;;

type unary_op= Uminus | Cos | Sin | Tan | Log | Exp | Sqrt | Abs;;

type indice=
  | N
  | I
  | Int of int
  | IBinOp of (binary_op * indice * indice)
;;

type expr =
  | Float of float
  | Var of indice
  | Ind of indice
  | UnOp of (unary_op*expr)
  | BinOp of (binary_op*expr*expr)
  | Sum of (indice*indice*expr)
  | Prod of (indice*indice*expr)
  | PowI of (expr*int)
;;
(* Type of arithmetic expression.*)

let string2var s =
  let len= String.length s in
  if s= "x" then Var (Int 1)
  else if len>1 then
    if s= "xi" then Var I
    else if s= "xn" then Var N
    else if s.[0]='x' then
      try let i= int_of_string (String.sub s 1 (len-1)) in
	Var (Int i) (*i-1*)
      with _-> failwith "string2var"
    else failwith "string2var"
  else failwith "string2var"
(*
    match s with
	"n" -> Ind N
      | "i" -> Ind I
      | _-> failwith "string2var"
*)
;;


let string2var2 s ind =
  if s="x" then Var ind
  else failwith "string2var2"
