open Expr_type

val string2expr: string -> expr
(** [string2expr fun_string] parses [fun_string] and returns an
  arithmetic expression of type [Expr_type.expr]. [fun_string] can
  contain the usual operations 
([+],[-],[*],[/]). Variables
  identified by the character [x] followed by a positive natural
  number (e.g. [x1], [x2]).
  An example for [fun_string] is ["(-x1)*(2*x2+3)"] *)


val eval: expr -> float array -> float
(** [eval expr x] returns the evaluation of the arithmetic expression [expr],
  replacing the terms [Var i] by their float values [x.(i)] *)

val range: expr -> Interval.interval array -> Interval.interval
(** [range expr xbounds] uses interval arithmetic to return the
  range of expression [expr], considering the bounds [xbounds] of
  each atomic variable. [xbounds.(i)] should contain the lower and
  upper bound associated to variable [Var i] in [expr]. *)
