(* File lexer.mll *)
{
open Parser        (* The type token is defined in parser.mli *)
exception Eof
let keyword_table = Hashtbl.create 53
let _ =
  List.iter (fun (kwd, tok) -> Hashtbl.add keyword_table kwd tok)
    [ "n",N;
      "i",I;
      "sum", SUM;
      "prod",PROD;
      "cos", COS;
      "sin", SIN;
      "tan", TAN;
      "log", LOG;
      "exp", EXP;
      "sqrt", SQRT ]
}

let digit= ['0'-'9']
rule token = parse
    [' ' '\t']     { token lexbuf }     (* skip blanks *)
  | digit+ ['.'] digit* as lxm     { FLOAT (float_of_string lxm) }
  | digit+ as lxm  { INT (int_of_string lxm) }
  | '+'            { PLUS }
  | '-'            { MINUS }
  | '*'            { TIMES }
  | '/'            { DIV }
  | '^'            { POW }
  | '('            { LPAREN }
  | ')'            { RPAREN }
  | '|'            { BAR }
  | ','            { COMMA }
  | ['A'-'Z' 'a'-'z'] ['A'-'Z' 'a'-'z' '0'-'9' '_'] * as id
      { try
          Hashtbl.find keyword_table id
        with Not_found ->
	  IDENT id }
  | eof            { EOF }
