/* File parser.mly */
%token <float> FLOAT
%token <int> INT
%token <string> IDENT
%token N I
%token PLUS MINUS TIMES DIV
%token COS SIN TAN LOG EXP SQRT SUM PROD POW
%token LPAREN RPAREN BAR COMMA
%left PLUS MINUS        /* lowest precedence */
%left TIMES DIV         /* medium precedence */
%nonassoc UMINUS COS SIN TAN LOG EXP SQRT SUM PROD POW  /* highest precedence */
%token EOF
%start main             /* the entry point */
%type <Expr_type.expr> main
%%
main:
    expr EOF { $1 }
  ;
expr:
    FLOAT                   { Expr_type.Float $1 }
  | IDENT LPAREN ind RPAREN { Expr_type.string2var2 $1 $3 }
  | IDENT                   { Expr_type.string2var $1 }
  | N                       { Expr_type.Ind Expr_type.N }
  | I                       { Expr_type.Ind Expr_type.I }
  | SUM LPAREN ind COMMA ind COMMA expr RPAREN
      {Expr_type.Sum ($3,$5,$7) }
  | PROD LPAREN INT COMMA INT COMMA expr RPAREN
      {Expr_type.Prod (Expr_type.Int $3,Expr_type.Int $5,$7) }
  | PROD LPAREN INT COMMA N COMMA expr RPAREN
      {Expr_type.Prod (Expr_type.Int $3,Expr_type.N,$7) }
  | LPAREN expr RPAREN      { $2 }
  | BAR expr BAR            { Expr_type.UnOp (Expr_type.Abs, $2) }
  | expr PLUS expr          { Expr_type.BinOp (Expr_type.Plus,$1,$3) }
  | expr MINUS expr         { Expr_type.BinOp (Expr_type.Minus,$1,$3) }
  | expr TIMES expr         { Expr_type.BinOp (Expr_type.Mult,$1,$3) }
  | expr DIV expr           { Expr_type.BinOp (Expr_type.Div,$1,$3) }
  | MINUS expr %prec UMINUS { Expr_type.UnOp (Expr_type.Uminus,$2) }
  | COS expr                { Expr_type.UnOp (Expr_type.Cos,$2) }
  | SIN expr                { Expr_type.UnOp (Expr_type.Sin,$2) }
  | TAN expr                { Expr_type.UnOp (Expr_type.Tan,$2) }
  | LOG expr                { Expr_type.UnOp (Expr_type.Log,$2) }
  | EXP expr                { Expr_type.UnOp (Expr_type.Exp,$2) }
  | SQRT expr               { Expr_type.UnOp (Expr_type.Sqrt,$2) }
  | expr POW INT            { Expr_type.PowI ($1,$3) }
  | expr POW expr           { Expr_type.BinOp (Expr_type.PowF,$1,$3) }
  ;
ind:
    I                      { Expr_type.I }
  | N                      { Expr_type.N }
  | INT                    { Expr_type.Int $1}
  | ind PLUS ind           { Expr_type.IBinOp (Expr_type.Plus,$1,$3) }
  | ind MINUS ind          { Expr_type.IBinOp (Expr_type.Minus,$1,$3) }
  | ind TIMES ind          { Expr_type.IBinOp (Expr_type.Mult,$1,$3) }
  | ind DIV ind          { Expr_type.IBinOp (Expr_type.Div,$1,$3) }
;
