let array_sort cmp a = Array.sort (fun x y -> cmp y x) a;;

(* calcul du barycentre de points.(0) ... points.(n-2) *)
let barycentre points =
  let n = Array.length points in
  let m = Array.length (fst points.(0)) in
  let b = Array.create m 0. in
  for i = 0 to n-2 do
    for j=0 to m-1 do
      b.(j) <- b.(j)+. (fst points.(i)).(j)
    done;
  done;
  for j=0 to m-1 do b.(j)<-b.(j)/. (float (n-1)) done;
  b;;
    
(* initialisation de l'ensemble des points du simplex *)
let init p alpha =
  let n = (Array.length p) in
  let v = Array.create_matrix (n+1) n 0.  in 
  for i = 0 to n do
    for j=0 to n-1 do
      if i <> (j+1) then
      	v.(i).(j) <- p.(j)
      else
      	v.(i).(j) <- p.(j)+. alpha
    done;
  done;
  v;;


let shift v0 vs = 
  for i = (Array.length vs)-1 downto 1 do
    vs.(i) <- vs.(i-1)
  done;
  vs.(0) <- v0;;
    
let distance x y = 
  let sum = ref 0. in 
  for i=0 to (Array.length x)-1 do
    sum:= !sum+. (x.(i)-. y.(i)) *. (x.(i)-. y.(i))
  done;
  !sum;;

let calcNew p b alpha = 
  let n = (Array.length p) in
  let newp = Array.create n 0. in
  for i=0 to n-1 do
    newp.(i)<- (p.(i)-. b.(i)) *. alpha +. b.(i)
  done;
  newp;;

(* maximisation de 'ff' en partant de 'p' en 'iterations' etapes max avec la precision 'precision'. 'alpha' sert d'amplitude pour la création du simplex*)
let simplex f p iterations alpha precision =
  if Func.disp then ignore (Graph.init());
  let l = init p alpha and n = Array.length p in
  let vs = (Array.map (fun x -> (x, f x)) l) in 
  array_sort (fun (_,x) (_,y) -> compare x y) vs;
  let num_iter = ref 1 in
  while (!num_iter<> iterations) & 
    ((distance (fst vs.(0)) (fst vs.(n)))>precision) do
    incr num_iter;
      if Func.disp then (
	Graph.reset();
	for i = 0 to Array.length vs -1 do
	  Graph.display (fst vs.(i));
	done;
	ignore(Graph.wait()));
      let vb = barycentre vs in
      let vr = calcNew (fst vs.(n)) vb (-1.0) in (* le point reflechi *)
      let fvr = f vr in 
      if fvr > snd vs.(0) then  
	(* Le point reflechi est meilleur que le meilleur element du*)
	(* simplexe. On calcule le point etendu *)
	let ve = calcNew (fst vs.(n)) vb (-2.0) in
	let fve = f ve in
	if fve > fvr then
          (* l'etendu est le meilleur. On le place en tete *)
	  shift (ve,fve) vs 
	else
          (*le reflechi est meilleur que l'etendu. On le place en tete*)
          shift (vr,fvr) vs 
      else 
      (* Ici le reflechi n'est pas meilleur que le meilleur point du*)
      (* simplexe. On va s'interesser au contracte *)
	let vc = calcNew (fst vs.(n)) vb 0.5 in
	let fvc = f vc in
	if fvc > snd vs.(n-1) or fvr > snd vs.(n-1) then
	(* Un des deux points, contracte ou reflechi, est meilleur que*)
	(* le plus mauvais element du simplexe *)
          let v = (if fvr > fvc then
              (vr,fvr) (* le reflechi est le meilleur *)
            else (vc,fvc)) in (* le contracte est le meilleur *)
          begin (* on insere le nouveau point a sa place *)
            let i = ref n in
            while !i > 0 & snd vs.(!i-1) < snd v do
	      vs.(!i) <- vs.(!i-1);
	      decr i
            done;
            vs.(!i) <- v
          end 
	else 
	  begin 
          (* Aucun des points n'ameliore le simplexe *)
          (* on contracte tout le simplexe autour du meilleur*)
	  (* element *)
            for i = 1 to n do
	      let vi = calcNew (fst vs.(i)) (fst vs.(0)) 0.5
	      in vs.(i) <- (vi, f vi)
            done;
	    array_sort (fun (_,x) (_,y) -> compare x y) vs
	  end
  done;
  (!num_iter,vs.(0))
    

