 let scale data =
   for i=0 to Func.dim -1 do
     data.(i)<- 
       if data.(i)>Func.highbound then 
	 data.(i)-.Func.delta
       else if data.(i)<Func.lowbound then 
	 data.(i)+.Func.delta 
       else data.(i);
   done;;


let iset = ref false;;
let gset = ref 0. ;;
exception Randg of float
let randgauss () = 
  iset:= not !iset;
  if (!iset) then (
    try 
      while true do
        let v1 = (Random.float 2.0) -. 1.0
        and v2 = (Random.float 2.0) -. 1.0 in
        let r = v1*.v1+.v2*.v2 in
        if r<1.0 then (
          let fac = sqrt (-2.0*.(log r)/.r) in
          gset := v1*.fac;
          raise (Randg (v2*.fac)))
      done;
      0.
    with
	Randg v -> v
      | exc -> raise exc)
  else
    !gset;;

let accept evalf neweval t = 
  (evalf-.neweval)<exp(-.t);;

let _ = 
  Random.init Func.seed;
  let inct = Func.inct in
  let dep = ref Func.dep in
  let ddep= Func.ddep in
  let elt=  Array.init Func.dim (fun i -> ((Random.float Func.delta)+.Func.lowbound)) in
  let evalf = ref (Func.f_x elt) in
  let t = ref 0. in
  scale elt;
  if Func.disp then ignore (Graph.init ());
  let count = ref 1 in
  let nb_iters = ref 0 in
  while true do
    decr count;
    incr nb_iters;
    dep := !dep *. ddep;
    let newelt = Array.copy elt in
    for i = 0 to Func.dim-1 do
      newelt.(i)<-newelt.(i)+. !dep*.randgauss()
    done;
    scale newelt;
    if Func.disp && (!count=0) then
      begin
	Graph.reset ();
	Graph.display elt Graphics.black;
	Graph.display newelt (Graphics.rgb 128 128 128);
	count := Graph.wait();
	count := if !count>1 then 10* !count else !count
      end;
    if !nb_iters mod Func.stepgen=0 then
      (Printf.printf "x=";
       Array.iter (fun x->Printf.printf "%f " x) elt;
       Printf.printf "\nfx=%f\n" !evalf;
       print_newline());
    let neweval = Func.f_x newelt in
(*    Printf.printf "%f %f\n" !evalf neweval; *)
    if neweval> !evalf or accept !evalf neweval !t then 
      begin
	Array.blit newelt 0 elt 0 Func.dim;
	evalf := neweval;
      end;
    t := !t+.inct;
  done;;
      

