(* L'lgance d'UNIX *)
(* let mysleep d = Unix.sleep d;; *)

(* Et cet infame Windows de malheur! Berk! *)
let mysleep d = 
  let t= Sys.time () in
  try 
    while true do
      let t2= Sys.time () in
      if (t2 -. t) > (float d) then raise Exit
    done
  with Exit -> ();;

type cint = int*int;;
type move = 
  | Move1 of cint*cint
  | Move2 of cint*cint*cint
  | MoveOut of cint*cint
  | Move3 of (cint*cint)*(cint*cint)
  | Move4 of (cint*cint)*(cint*cint)*(cint*cint);;


module Int64Set = Mset.Make(struct type t = int64 let compare = compare end);;
let hashset = ref Int64Set.empty;;

let addhash v = 
  hashset := Int64Set.add v !hashset;;

let add_find_hash v = 
  let (s,b) = Int64Set.add_find v !hashset in
  hashset := s;
  b;;

let remhash v = 
  hashset := Int64Set.remove v !hashset;;

let is_in_hash v = 
  Int64Set.mem v !hashset;;


let dep = [|(1,0);(1,1);(0,1);(-1,0);(-1,-1);(0,-1)|];;
let forbid = 2;;
let white = 1;;
let black = -1;;
let empty = 0;;
let tab = Array.create_matrix 11 11 empty;;
let tabhash = Array.init 4
    (fun i -> if i = 2 then [||] else Array.init 11
	(fun _ -> Array.init 11
	    (fun _ -> 
	      let a = Int64.of_int (Random.bits ())
	      and b = Int64.of_int (Random.bits ())
	      and c = Int64.of_int (Random.bits () land 0x7) in
	      Int64.add (Int64.shift_left a 1)
		(Int64.add (Int64.shift_left b 31)
		   (Int64.shift_left c 61)))));;
let hashval = ref (Int64.zero);;
let colons = Array.create 11 0
and lignes = Array.create 11 0
and diags = Array.create 11 0;;
let out_black = ref 0;;
let out_white = ref 0;;
let move_list = ref [];;
let bmove = ref None;;

let (stdcoefsw,stdcoefsb : int array array*int array array) = 
  let fp = open_in "stdcoefs" in
  let res = input_value fp in
  close_in fp;
  res;;


let add_move m move_list = 
  move_list := (m,Array.copy colons,Array.copy lignes,Array.copy diags)
    :: !move_list;;

let init_tab () = 
  for i = 0 to Array.length tab -1 do
    for j = 0 to Array.length tab.(0) -1 do
      tab.(i).(j) <- 0
    done
  done;
  let x = ref 0 and y = ref 0 in
  for i = 0 to 5 do
    let (a,b)=dep.(i) in
    for j=0 to 4 do
      tab.(!x).(!y) <- forbid;
      x := !x+a;y:= !y+b;
    done;
    tab.(!x).(!y)<-forbid;
  done;
  let f il ih j c = 
    for i = il to ih do
      tab.(j).(i) <- c
    done in
  f 1 5 1 white;
  f 1 6 2 white;
  f 3 5 3 white;
  f 5 9 9 black;
  f 4 9 8 black;
  f 5 7 7 black;;

  
let build_vects () = 
  for i = 0 to Array.length colons -1 do
    colons.(i) <-0;lignes.(i) <- 0; diags.(i)<- 0
  done;
  for i = 1 to 9 do
    for j = max 1 (i-4) to min 9 (i+4) do
      if tab.(i).(j)<>0 then
	begin
	  let v = tab.(i).(j) land  0x3 in
	  let dec = if i<5 then (j-1) else (j+5-i-1) in
	  colons.(i) <- colons.(i) lor (v lsl (dec*2));
	  let dec = if j<5 then (i-1) else (i+5-j-1) in
	  lignes.(j) <- lignes.(j) lor (v lsl (dec*2));
	  let k = i-j+5 in
	  let dec = if k>5 then j-1 else j+k-5-1 in
	  diags.(k) <- diags.(k) lor (v lsl (dec*2))
	end
    done
  done;;

let init_graph () =
  Graphics.open_graph "unix:0 600x600";
  Graphics.auto_synchronize false;;

let init () = 
  init_tab ();build_vects ();move_list:=[];hashval:=Int64.zero;
  hashset := Int64Set.empty;
  out_black := 0; out_white := 0;bmove:=None;;


let affiche i j v =
  let c = 
    if v=white then Graphics.green
    else if v=black then Graphics.red
    else Graphics.black in
  Graphics.set_color c;
  let y = i*60+10 and x = j*60-i*30+150 in
  Graphics.fill_circle x y 20;
  Graphics.set_color Graphics.white;
  Graphics.moveto (x-5) (y-5);
  let s = (Printf.sprintf "%d,%d" j i) in
  Graphics.draw_string s ;;

let affiche_tout () = 
  Graphics.clear_graph ();
  for i = 1 to 9 do
    for j = max 1 (i-4) to min 9 (i+4) do
      affiche i j tab.(i).(j)
    done;
  done;
  Graphics.moveto 20 20;
  Graphics.set_color Graphics.green;
  let s = Printf.sprintf "%d" !out_white in
  Graphics.draw_string s;
  Graphics.moveto 20 40;
  Graphics.set_color Graphics.red;
  let s = Printf.sprintf "%d" !out_black in
  Graphics.draw_string s;
  Graphics.synchronize ();;

exception Good of move;;
exception Good2 of move;;
exception Check;;
exception Bad;;

let evalcp ((x,y),(fx,fy)) = 
  (x-5)*(x-5) +(y-5)*(y-5) - (fx-5)*(fx-5) - (fy-5)*(fy-5);;


let genmoves col quiet =
  let std_moves = ref [] and good_moves = ref [] in
  for i = 1 to 9 do
    for j = max 1 (i-4) to min 9 (i+4) do
      if tab.(i).(j) = col then
	begin
	  for n = 0 to 5 do
	    let (dx,dy) = dep.(n) and x = ref i and y = ref j and cpt = ref 1 in
	    try
	      (try 
	      	while !cpt <= 3 do
	      	  x := !x+dx; y := !y+dy; 
	      	  let p = tab.(!x).(!y) in
	      	  if p = col then incr cpt
	      	  else if p = empty then 
		    if quiet then raise Bad 
		    else raise (Good (Move1 ((i,j),(!x,!y))))
	      	  else if p = -col then if !cpt>1 then raise Check else raise Bad
	      	  else if p = forbid then raise Bad
	      	done;
	      	raise Bad
	      with
	      	Check ->
	      	  let cpt2 = ref 1 and tx = !x and ty = !y in
	      	  while !cpt2 < !cpt do
	      	    x := !x+dx; y := !y+dy; 
	      	    let p = tab.(!x).(!y) in
		    if p = -col then incr cpt2
		    else if p = col then raise Bad
		    else if p = empty then 
		      if quiet then raise Bad 
		      else raise (Good (Move2 ((i,j),(tx,ty),(!x,!y)) ))
		    else if p = forbid then raise (Good2 (MoveOut ((i,j),(tx,ty))))
	      	  done;
	      	  raise Bad)
	    with
	      Bad -> ()
	    | Good x -> 
	      	let v = match x with 
		  Move1(a,b) -> evalcp (a,b) 
	      	| Move2(a,b,c) -> (evalcp (a,b) )-(evalcp (b,c) ) 
		| _ -> failwith "Good match failure" in 
	      	std_moves := (x,v):: !std_moves
	    | Good2 x -> 
		let v = match x with 
		  MoveOut(a,b) -> evalcp (a,b) 
		| _ -> failwith "Good2 match failure" in 
		good_moves := (x,v) :: !good_moves
	  done;

	  if not quiet then (
	    for n=0 to 5 do
	      let (dx,dy) = dep.(n) in
	      if tab.(i+dx).(j+dy) = empty then
		for m = 0 to 2 do
		  if m<>n && (m+3)<>n then
		    let (dx2,dy2) = dep.(m) in
		    if tab.(i+dx2).(j+dy2) = col then 
		      if tab.(i+dx2+dx).(j+dy2+dy) = empty then
			begin
		      	  let a = ((i,j),(i+dx,j+dy)) 
			  and b = ((i+dx2,j+dy2),(i+dx+dx2,j+dy+dy2)) in
		      	  let v = (evalcp a ) + (evalcp b ) in
		      	  std_moves := (Move3 (a,b),v)  :: !std_moves;
		      	  if tab.(i+dx2+dx2).(j+dy2+dy2) = col then
			    if tab.(i+dx2+dx2+dx).(j+dy2+dy2+dy) = empty then
			      let c = ((i+dx2+dx2,j+dy2+dy2),(i+dx2+dx2+dx,j+dy2+dy2+dy)) in
			      let v = v+(evalcp c ) in
			      std_moves := (Move4(a,b,c),v) :: !std_moves
			end
		done
	    done);
	end;
    done;
  done;
  !good_moves @ (List.sort (fun (_,v1) (_,v2) -> -(compare v1 v2)) !std_moves);;

let modif i j newv = 
  let v = (tab.(i).(j) lxor newv) land 0x3 in
  let dec = if i<5 then (j-1) else (j+5-i-1) in
  colons.(i) <- colons.(i) lxor (v lsl (dec*2));
  let dec = if j<5 then (i-1) else (i+5-j-1) in
  lignes.(j) <- lignes.(j) lxor (v lsl (dec*2));
  let k = i-j+5 in
  let dec = if k>5 then j-1 else j+k-5-1 in
  diags.(k) <- diags.(k) lxor (v lsl (dec*2));
  hashval := Int64.logxor !hashval tabhash.(tab.(i).(j) land 0x3).(i).(j);
  hashval := Int64.logxor !hashval tabhash.(newv land 0x3).(i).(j);
  tab.(i).(j)<-newv;;


let affiche_coup = 
  let print_one ((x,y),(tx,ty)) = 
    Printf.printf "(%d,%d)->(%d,%d) " y x ty tx in
  function
      (Move1 (a,b),v) -> 
      	print_one (a,b) ; Printf.printf ":%d " v
    | (Move3 (a,b),v) ->
	print_one a ; print_one b;Printf.printf ":%d " v
    | (Move4 (a,b,c),v) ->
	print_one a ; print_one b;print_one c;Printf.printf ":%d " v
    | (Move2 ((x,y),(tx,ty),(fx,fy)),v) -> 
      	Printf.printf "(%d,%d)->(%d,%d->(%d,%d):%d "y x ty tx fy fx v
    | (MoveOut ((x,y),(tx,ty)),v) -> 
      	Printf.printf "(%d,%d)->(%d,%d):%d " y x ty tx v;;

let cvt_move = 
  let print_one ((x,y),(tx,ty)) = Printf.sprintf "%d%d%d%d" y x ty tx in
  function
      Move1 (a,b) -> 
      	print_one (a,b)
    | Move3 (a,b) ->
	(print_one a)^(print_one b)
    | Move4 (a,b,c) ->
	(print_one a)^(print_one c)
    | Move2 (a,b,c) -> 
	print_one (a,b)
    | MoveOut (a,b)-> 
	print_one (a,b);;


let affiche_coups l = 
  List.iter affiche_coup l;;

let play_move = function m -> 
  let play_one ((x,y),(tx,ty)) = 
    modif tx ty tab.(x).(y);
    modif x y empty in
  let f = function
      Move1 (a,b) -> play_one (a,b) 
    | Move3 (a,b) -> play_one a;play_one b
    | Move4 (a,b,c) -> play_one a;play_one b;play_one c
    | Move2 ((x,y),(tx,ty),(fx,fy)) ->
	modif fx fy tab.(tx).(ty);
	play_one ((x,y),(tx,ty))
    | MoveOut ((x,y),(tx,ty)) -> 
      	if tab.(x).(y) = white then incr out_black else incr out_white;
	play_one ((x,y),(tx,ty)) in
  f m;
  hashval := Int64.logxor !hashval Int64.one;
  addhash !hashval;;

let play_move2 = function m -> 
  let play_one ((x,y),(tx,ty)) = 
    modif tx ty tab.(x).(y);
    modif x y empty in
  let f = function
      Move1 (a,b) -> play_one (a,b) 
    | Move3 (a,b) -> play_one a;play_one b
    | Move4 (a,b,c) -> play_one a;play_one b;play_one c
    | Move2 ((x,y),(tx,ty),(fx,fy)) ->
	modif fx fy tab.(tx).(ty);
	play_one ((x,y),(tx,ty))
    | MoveOut ((x,y),(tx,ty)) -> 
      	if tab.(x).(y) = white then incr out_black else incr out_white;
	play_one ((x,y),(tx,ty)) in
  f m;
  hashval := Int64.logxor !hashval Int64.one;
  add_find_hash !hashval;;
  
let undo_move m = 
  let undo_one ((x,y),(tx,ty)) = 
    modif x y tab.(tx).(ty);
    modif tx ty empty in
  let f = function
      Move1 (a,b) -> undo_one (a,b)
    | Move3 (a,b) -> undo_one a;undo_one b
    | Move4 (a,b,c) -> undo_one a;undo_one b;undo_one c
    | Move2 ((x,y),(tx,ty),(fx,fy)) ->
	modif x y  tab.(tx).(ty);
	undo_one ((tx,ty),(fx,fy))
    | MoveOut ((x,y),(tx,ty)) -> 
	modif x y tab.(tx).(ty);
	modif tx ty  (-tab.(tx).(ty));
      	if tab.(x).(y) = white then decr out_black else decr out_white in
  remhash !hashval;
  f m;
  hashval := Int64.logxor !hashval Int64.one;;

let rec alpha_beta mcolor color prof maxprof alpha beta lrn = 
  if prof=maxprof then
    begin
      let res = ref 0 in
      let (coefsw,coefsb) = (stdcoefsw,stdcoefsb)
      in
      let coefs = if color=white then coefsw else coefsb in
      for i = 1 to 9 do
	let i1 = min (i-1) (9-i) in
	res:= !res + coefs.(i1).(colons.(i));
	res:= !res + coefs.(i1).(lignes.(i));
	res:= !res + coefs.(i1).(diags.(i))
      done;
      let v = !res+ 512 * (!out_black * !out_black - !out_white * !out_white) in
      if mcolor=1 then v else -v
    end
  else 
    begin
      let mlist = genmoves color false in
      if color=mcolor then 
	begin
	  let a = ref alpha in
	  (try 
      	    List.iter 
      	      (fun (coup,cv) ->
      		let deja=play_move2 coup in
		let res = 
		  if deja then 0
		  else if !out_black=6 then if mcolor=white then 32767 else -32767
		  else if !out_white=6 then if mcolor=black then 32767 else -32767
      		  else alpha_beta mcolor (-color) (prof+1) maxprof !a beta lrn in
		undo_move coup;
		if res > !a then 
		  begin
		    a := res;
		    if prof=0 then 
		      begin
			bmove := Some coup;
		      end;
		  end;
      		if !a >= beta then raise Exit)
      	      mlist;
	  with Exit -> ());
	  !a
	end
      else
	begin
	  let b = ref beta in
	  (try 
      	    List.iter 
      	      (fun (coup,_) ->
      		let deja = play_move2 coup in
		let res = 
		  if deja then 0
		  else if !out_black=6 then if mcolor=white then 32767 else -32767
		  else if !out_white=6 then if mcolor=black then 32767 else -32767
      		  else alpha_beta mcolor (-color) (prof+1) maxprof alpha !b lrn in
		b := min !b res;
		undo_move coup;
		if !b <= alpha then raise Exit)
      	      mlist;
	  with Exit -> ());
	  !b
	end
    end;;

exception Error;;
exception Sortie of move;;

let convert_and_play n color = 
  try (
    let mlist = genmoves color false in
    (if n<10000 then
      let k = n mod 10 and l = (n/10) mod 10 and i = (n/100) mod 10 and j = (n/1000) mod 10 in
      List.iter (function (coup,_) -> 
      	try 
	  let ((x,y),(fx,fy)) = match coup 
	  with 
	    Move1((x,y),(fx,fy)) -> ((x,y),(fx,fy))
	  | MoveOut((x,y),(fx,fy)) -> ((x,y),(fx,fy))
	  | Move2((x,y),(tx,ty),(fx,fy)) -> ((x,y),(tx,ty)) 
	  | _ -> raise Error in
	  if ((x,y),(fx,fy)) = ((i,j),(k,l)) then raise (Sortie coup);
      	with 
	  Error -> ()) mlist;
    else
      let k = n mod 10 and l = (n/10) mod 10 and i = (n/100) mod 10 and j = (n/1000) mod 10 in
      let n = n/10000 in
      let k1 = n mod 10 and l1 = (n/10) mod 10 and i1 = (n/100) mod 10 and j1 = (n/1000) mod 10 in
      let med = (max (abs (i-i1)) (abs (j-j1))) = 1 in
      List.iter (function (coup,_) -> 
      	try 
	  if  med then
	    (match coup with 
	      Move3(((x,y),(w,z)),((x1,y1),(w1,z1))) -> 
	      	if (((x,y),(w,z)),((x1,y1),(w1,z1)))=(((i,j),(k,l)),((i1,j1),(k1,l1))) 
		    or (((x,y),(w,z)),((x1,y1),(w1,z1)))=(((i1,j1),(k1,l1)),((i,j),(k,l))) then raise (Sortie coup);
	    | _ -> raise Error)
	  else
	    (match coup with 
	      Move4(((x,y),(w,z)),_,((x1,y1),(w1,z1))) -> 
	      	if (((x,y),(w,z)),((x1,y1),(w1,z1)))=(((i,j),(k,l)),((i1,j1),(k1,l1))) 
		    or (((x,y),(w,z)),((x1,y1),(w1,z1)))=(((i1,j1),(k1,l1)),((i,j),(k,l))) then raise (Sortie coup);
	    | _ -> raise Error)
      	with 
	  Error -> ()) mlist);
    false)
  with
    (Sortie coup) -> 
      play_move coup;
      add_move coup move_list;
      affiche_tout ();
      true;;

let back_move () = 
  if (List.length !move_list) >1 then
    begin
      let (move,_,_,_) = List.hd !move_list in
      undo_move move;
      move_list := List.tl !move_list;
      let (move,_,_,_) = List.hd !move_list in
      undo_move move;
      move_list := List.tl !move_list;
      affiche_tout ()
    end;;

let opponent_move color = 
  try 
    while true do
      try (
	Printf.printf "Your move:";flush stdout;
	let line = input_line stdin in
	if line = "u" then back_move ()
	else
	  let n = int_of_string line in
	  if (convert_and_play n color) then raise Exit)
      with Failure _ -> ()
    done
      with Exit -> ();;


let rec print_bin i =
  if i = 0 then ()
  else
    let v = i land 0x3 in
    print_bin (i lsr 2);
    match v with
      0 -> print_string "e"
    | 1 -> print_string "w"
    | 3 -> print_string "b"
    | 2 -> print_string "f"
    | _ -> failwith "print_bin";;

let f3 () =  
  init_graph ();
  let col =  white in
  while true do
    bmove := None;
    ignore (alpha_beta col col 0 5 (-32768) 32768 false);
    (match !bmove with
      Some m -> 
	for i = 1 to 5 do
	  play_move m;affiche_tout (); mysleep 1;
	  undo_move m;affiche_tout (); mysleep 1;
	done;
	play_move m; add_move m move_list; affiche_tout ()
    | None -> print_string "No moves !!!!\n";flush stdout);
    if !out_black=6 or !out_white=6 then raise Exit;
    opponent_move (-white);
    affiche_tout();
  done;;

let _ = 
  init ();
  (try f3 () with 
    Exit -> ()
  | x -> print_string (Printexc.to_string x);print_newline ());
  print_string "fin de partie";
  print_newline();
  let _ = input_line stdin in
  exit 0;;

