(*
    Copyright 2011 Jean-Marc Alliot

    This file is part of the mpfi/mpfr bindings.

    The mpfi/mpfr bindings is free software: 
    you can redistribute it and/or modify it under the terms of 
    the GNU Lesser General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The mpfi/mpfr bindings is distributed in the hope that it will be 
    useful,but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public 
    License along with the mpfi/mpfr bindings.  
    If not, see <http://www.gnu.org/licenses/>.
*)

type t
type rounding = 
    Both_Endpoints_Exact
  | Left_Endpoint_Inexact
  | Right_Endpoint_Inexact
  | Both_Endpoints_Inexact;;
external init : unit -> t ="caml_mpfi_init"
external init2 : int -> t ="caml_mpfi_init2"
external mpfi_set_prec : t -> int -> unit ="caml_mpfi_set_prec"
external mpfi_get_prec : t -> int ="caml_mpfi_get_prec"
external mpfi_round_prec : t -> int -> rounding ="caml_mpfi_round_prec"
external set : t -> t -> rounding = "caml_mpfi_set"
external set_d : t -> float -> rounding = "caml_mpfi_set_d"
external set_str : t -> string -> int -> rounding = "caml_mpfi_set_str"
external add : t -> t -> t -> rounding = "caml_mpfi_add"
external sub : t -> t -> t -> rounding = "caml_mpfi_sub"
external mul : t -> t -> t -> rounding = "caml_mpfi_mul"
external div : t -> t -> t -> rounding = "caml_mpfi_div"
external neg : t -> t -> rounding = "caml_mpfi_neg"
external inv : t -> t -> rounding = "caml_mpfi_inv"
external sqr : t -> t -> rounding = "caml_mpfi_sqr"
external sqrt : t -> t -> rounding = "caml_mpfi_sqrt"
external abs : t -> t -> rounding = "caml_mpfi_abs"
external log : t -> t -> rounding = "caml_mpfi_log"
external exp : t -> t -> rounding = "caml_mpfi_exp"
external exp2 : t -> t -> rounding = "caml_mpfi_exp2"
external cos : t -> t -> rounding = "caml_mpfi_cos"
external sin : t -> t -> rounding = "caml_mpfi_sin"
external tan : t -> t -> rounding = "caml_mpfi_tan"
external acos : t -> t -> rounding = "caml_mpfi_acos"
external asin : t -> t -> rounding = "caml_mpfi_asin"
external atan : t -> t -> rounding = "caml_mpfi_atan"
external acosh : t -> t -> rounding = "caml_mpfi_acosh"
external asinh : t -> t -> rounding = "caml_mpfi_asinh"
external atanh : t -> t -> rounding = "caml_mpfi_atanh"
external cosh : t -> t -> rounding = "caml_mpfi_cosh"
external sinh : t -> t -> rounding = "caml_mpfi_sinh"
external tanh : t -> t -> rounding = "caml_mpfi_tanh"
external log1p : t -> t -> rounding = "caml_mpfi_log1p"
external expm1 : t -> t -> rounding = "caml_mpfi_expm1"
external log2 : t -> t -> rounding = "caml_mpfi_log2"
external log10 : t -> t -> rounding = "caml_mpfi_log10"
external add_d : t -> t -> float -> rounding = "caml_mpfi_add_d"
external sub_d : t -> t -> float -> rounding = "caml_mpfi_sub_d"
external mul_d : t -> t -> float -> rounding = "caml_mpfi_mul_d"
external div_d : t -> t -> float -> rounding = "caml_mpfi_div_d"
external d_sub : t -> float -> t -> rounding = "caml_mpfi_d_sub"
external d_div : t -> float -> t -> rounding = "caml_mpfi_d_div"
external get_d : t -> float = "caml_mpfi_get_d"
external const_log2 : t -> rounding = "caml_mpfi_const_log2"
external const_pi : t -> rounding = "caml_mpfi_const_pi"
external const_euler : t -> rounding = "caml_mpfi_const_euler"
(* Be VERY careful. The standard mpfi cmp function is NOT 
compatible with usual ocaml compare functions because it
can return 0 even if intervals are NOT equal !!! *)
external cmp : t -> t -> int = "caml_mpfi_cmp"
external cmp_d : t -> float -> int = "caml_mpfi_cmp_d"
external cmp_is_pos : t -> int = "caml_mpfi_is_pos"
external cmp_is_strictly_pos : t -> int = "caml_mpfi_is_strictly_pos"
external cmp_is_neg : t -> int = "caml_mpfi_is_neg"
external cmp_is_strictly_neg : t -> int = "caml_mpfi_is_strictly_neg"
external cmp_is_nonpos : t -> int = "caml_mpfi_is_nonpos"
external cmp_is_zero : t -> int = "caml_mpfi_is_zero"
external cmp_has_zero : t -> int = "caml_mpfi_has_zero"
external cmp_nan_p : t -> int = "caml_mpfi_nan_p"
external cmp_inf_p : t -> int = "caml_mpfi_inf_p"
external cmp_bounded_p : t -> int = "caml_mpfi_bounded_p"
(* out_str always output on stdio, the FILE* is not implemented *)
external out_str : int -> int -> t -> int = "caml_mpfi_out_str"

(* These function need Mpfr bindings because they return Mpfr.t type. 
You can remove them if you don't have these bindings*)
external mpfi_get_right : Mpfr.t -> t -> int ="caml_mpfi_get_right"
external mpfi_get_left : Mpfr.t -> t -> int ="caml_mpfi_get_left"

(* The next two functions are not part of mpfi, but are useful 
if mpfr bindings are not available. The above two functions must be
use instead when possible *)
external get_left_d : t -> float = "caml_mpfi_get_left_d"
external get_right_d : t -> float = "caml_mpfi_get_right_d"

(*
(* Only available in mpfi 1.5.1 *)
external cbrt : t -> t -> rounding = "caml_mpfi_cbrt"
external atan2 : t -> t -> t -> rounding = "caml_mpfi_atan2"
external sec : t -> t -> rounding = "caml_mpfi_sec"
external csc : t -> t -> rounding = "caml_mpfi_csc"
external cot : t -> t -> rounding = "caml_mpfi_cot"
external sech : t -> t -> rounding = "caml_mpfi_sech"
external csch : t -> t -> rounding = "caml_mpfi_csch"
external coth : t -> t -> rounding = "caml_mpfi_coth"
external hypot : t -> t -> t -> rounding = "caml_mpfi_hypot"
external const_catalan : t -> rounding = "caml_mpfi_const_catalan"
*)

